/*
 * KnapsackProblem.cpp
 *
 *  Created on: 28/05/2013
 *      Author: Andre L. Maravilha
 */


#include <ctime>
#include <cstdlib>
#include <iostream>
#include <deque>
#include <gurobi_c++.h>
using namespace std;

int main(int argc, char* argv[]) {

	// Initializes the random number generator
	srand(time(NULL));

	// Creates a random problem
	int size = 10000;
	double capacity = 1000;
	deque<double> profit;
	deque<double> weight;

	for (int i = 0; i < size; ++i) {
		profit.push_back(rand() % 1000);
		weight.push_back(rand() % 1000);
	}

	try {

		GRBEnv env = GRBEnv();
		GRBModel model = GRBModel(env);

		// Set some parameters
		model.getEnv().set(GRB_IntParam_OutputFlag, 0);
		model.getEnv().set(GRB_DoubleParam_TimeLimit, 1.0);
		//model.getEnv().set(GRB_DoubleParam_Cutoff, 1000);

		// Create variables
		deque<GRBVar> vars;
		for (int i = 0; i < size; ++i) {
			GRBVar x = model.addVar(0.0, 1.0, 0.0, GRB_BINARY);
			vars.push_back(x);
		}

		// Integrate new variables
		model.update();

		// Set Objective
		GRBLinExpr objective;
		for (int i = 0; i < size; ++i) {
			objective += profit[i] * vars[i];
		}

		model.setObjective(objective, GRB_MAXIMIZE);

		// Add constraints
		GRBLinExpr constraint;
		for (int i = 0; i < size; ++i) {
			constraint += weight[i] * vars[i];
		}

		model.addConstr(constraint <= capacity);

		// Optimize the model
		model.optimize();

		// Show the result
		cout << endl;
		cout << "Itens in the knapsak:" << endl;
		cout << "[ ";
		for (int i = 0; i < size; ++i) {
			if (vars[i].get(GRB_DoubleAttr_X) > 0.5) {
				cout << i << " ";
			}
		}
		cout << "]" << endl;

		cout << endl;
		cout << "Profit: " << model.get(GRB_DoubleAttr_ObjVal) << endl;
		cout << "Elapsed time: " << model.get(GRB_DoubleAttr_Runtime);

	} catch (GRBException& e) {
		cout << "Error code: " << e.getErrorCode() << endl;
		cout << e.getMessage() << endl;
	} catch (...) {
		cout << "Exception during optimization." << endl;
	}

}
