%==========================================================================
% Universidade Federal de Minas Gerais
% Escola de Engenharia da UFMG
% Depto. de Engenharia Eltrica
%
% Autores:
%   Jaime A. Ramrez
%   Lucas S. Batista
%
% Atualizao: 16/04/2013
%
% Nota:
%   Imprime a soluo atual, o nmero de iteraes (k), e a trajetria
%   percorrida at que se atinja o ponto de timo (probs. com 2 variveis)
% =========================================================================


function output (fun, vetor, k, xlimites)

%
% Sintaxe
% output (fun, vetor, k, xlimites)
% fun     : funo objetivo
% vetor   : conjunto de solues determinadas at a iterao k
% k       : iterao corrente
% xlimites: limites inferior e superior das variveis 
%           [x1min x1max x2min x2max ... xnmin xnmax]
%

% -------------------------------------------------------------------------
% Imprime a soluo corrente na tela de comandos do MatLab
if (k == 0) fprintf('\n'), end

tam   = length(xlimites);
[L,C] = size(vetor);

fprintf(1, 'x = [')
fprintf(1, '%+6.4f  ', vetor(L,1:end-1)')
fprintf(1, '\b\b]; \t f(x) = %+6.4f; \t k = %d\n', vetor(L,end),k)
% -------------------------------------------------------------------------

% Esta parte do cdigo  definida apenas para funes com duas variveis 
% (2D). Caso contrrio, o processo de otimizao continua, porm, a 
% trajetria das solues determinadas no  plotada.
if (tam ~= 4)    
    return
end

% -------------------------------------------------------------------------
% Este 'if'  acessado apenas uma vez, com o objetivo de plotar as curvas
% de nvel da funo objetivo
if (k == 0)
    % fecha a janela corrente
    close
    
    % Plota as curvas de nvel da funo objetivo    
    deltax = (xlimites(2) - xlimites(1))/30;
    deltay = (xlimites(4) - xlimites(3))/30;
    [x, y] = meshgrid(xlimites(1):deltax:xlimites(2), ...
                      xlimites(3):deltay:xlimites(4));    
    hold on
    z = fitnessEvaluation(fun, x, y);      
    cnivel = [linspace(0,vetor(L,end),10) linspace(vetor(L,end),vetor(L,end)+50,10)];
    
    % Plot em 2D
    c = contour(x,y,z,cnivel); clabel(c), grid on
    
    % ou,
    
    % Plot em 3D
    %mesh(x,y,z); box on, view([30 70])
end
% -------------------------------------------------------------------------

% -------------------------------------------------------------------------
% Imprime o processo iterativo
xlabel('x1'), ylabel('x2'), zlabel('f(x)')
plot3 (vetor(:,1), vetor(:,2), vetor(:,3), 'k*-')
axis(xlimites);
if (k == 0), pause, else pause(0.01), end
% -------------------------------------------------------------------------



