%==========================================================================
% Universidade Federal de Minas Gerais
% Escola de Engenharia da UFMG
% Depto. de Engenharia Eltrica
%
% Autores:
%   Jaime A. Ramrez
%   Lucas S. Batista
%
% Atualizao: 16/04/2013
%
% Nota:
%   Estima o gradiente de uma funo no ponto especificado.
% =========================================================================


function g = gradienteVector (fun, x)

% Gradiente analtico da funo 'fun'
switch func2str(fun)
    case 'fobj1'
        g(1) = 4*(x(1)-2)^3 + 2*(x(1)-2*x(2));
        g(2) = -4*(x(1)-2*x(2));
    case 'fobj2'
        g(1) = -400*x(1)*(x(2)-x(1)^2)^2 - 2*(1-x(1));
        g(2) = 200*(x(2)-x(1)^2);
    otherwise
        disp('Vetor gradiente no definido!')
end

g = g(:);



