%==========================================================================
% Universidade Federal de Minas Gerais
% Escola de Engenharia da UFMG
% Depto. de Engenharia Eltrica
%
% Autores:
%   Jaime A. Ramrez
%   Lucas S. Batista
%
% Atualizao: 16/04/2013
%
% Nota:
%   Aproxima o ponto de timo (minimizao) de um problema irrestrito
%   usando o Algoritmo do Gradiente (VERSO SIMPLES - MERAMENTE ILUSTRATIVA).
% =========================================================================


function gradienteMethod (fun, x, e, xlimites)

%
% Sintaxe
% gradienteMethod(fun, x, e, xlimites)
% fun     : funo objetivo
% x       : vetor soluo inicial [x1 x2 ... xn]
% e       : preciso adotada pelo usurio
% xlimites: limites inferior e superior das variveis 
%           [x1min x1max x2min x2max ... xnmin xnmax]
%
% Exemplo
% gradienteMethod(@fobj1, [+3.0 +3.0], 0.01, [0 4 0 4])
% gradienteMethod(@fobj2, [-1.0 +1.5], 0.01, [-1.5 1.5 -1.0 1.5])
%


% Contador de iteraes do mtodo
k = 0;

% Garante que x seja um vetor coluna
x = x(:);

% Garante que x respeite as restries de caixa
x = boxConstraints(x, xlimites);

g = gradienteVector(fun, x);  % Estima o grandiente da funo no ponto x
d = -g;                       % Determina a direo de busca

% Estima o valor de 'alpha^*' usando o Algoritmo da Seo urea
alpha = unidimensionalOptimization(fun, x, d);

% Armazena o caminho percorrido em direo ao timo
caminho(k+1,:) = [x' feval(fun, x)];

% Imprime o resultado da busca encontrado at a iterao k
output(fun, caminho, k, xlimites); 


% Critrio de parada: condio necessria de primeira ordem (||g|| = 0)
while (norm(g) >= e)            
    x = x + alpha*d;                 % Determina a nova soluo  
    x = boxConstraints(x, xlimites); % Verifica a restrio de caixa
    g = gradienteVector(fun, x);% Calcula o grandiente da funo no ponto x
    d = -g;                     % Determina a direo de busca    
    k = k + 1;                  % Atualiza o contador
    
    % Estima um novo valor para 'alpha^*'
    alpha = unidimensionalOptimization(fun, x, d); 
    
    % Armazena o caminho percorrido em direo ao timo
    caminho(k+1,:) = [x' feval(fun, x)];
    
    % Atualiza o percusso em direo ao timo
    output(fun, caminho, k, xlimites);    
end
fprintf('\n')

figure
plot(0:k,caminho(:,end),'k-','linewidth',2)
xlabel('Nmero de iteraes')
ylabel('Valor da funo objectivo')
