close all
clear all

% Define a semente do gerador de números aleatórios
rng(1);

% Cria uma instância aleatória para o problema da mochila
n = 5000;                   % número de nós
c = ceil(100 * rand(1, n)); % benefício
a = 100 * rand(1, n);       % peso
b = ceil(sum(a) * 0.65);    % capacidade da mochila

% Cria a formulação para o TSP
try
    
    % Natureza das variáveis
    model.vtype = 'B';
    
    % Função objetivo
    model.modelsense = 'max';
    model.obj = c;
    
    % Restrições
    model.A = sparse(a);
    model.rhs = b;
    model.sense = '<';
    
    % Parâmetros para o Gurobi
    params.outputflag = 1;      % exibe o log
    params.heuristics = 0;      % utiliza heurísticas o mínimo possível
    params.prepasses = -1;      % realiza o mínimo de pré-processamento
    params.threads = 1;         % número de threads
    
    % Resolve o modelo
    result = gurobi(model, params);
    
    % Exibe o resultado
    disp(result);
    fprintf('Obj: %e\n', result.objval);
    
catch gurobiError
    fprintf('Ocorreu um erro durante a execução do Gurobi');
end
