function drawlp(A,b,c,xrang,resolution,ncontour,type)
%=========================================================================
if nargin < 5,
    resolution = 0.1;
end
if nargin < 6,
    ncontour = 10;
end
if nargin < 7,
    type = 2;
end
%=========================================================================
h = figure;
grid minor
hold on
axis([xrang(1,:) xrang(2,:)]);
%=========================================================================
xt1 = [xrang(1,1):resolution:xrang(1,2)];
xt2 = [xrang(2,1):resolution:xrang(2,2)];
for i = 1:size(A,1),
    if A(i,1) == 0,
        x1(i,:) = xt1;
        x2(i,:) = b(i)*ones(1,length(xt2));
    elseif A(i,2) == 0,
        x1(i,:) = b(i)*ones(1,length(xt1));
        x2(i,:) = xt2;
    else
        x1(i,:) = xt1;
        x2(i,:) = (b(i) - A(i,1)*x1(i,:)) / A(i,2);
    end
end
%=========================================================================
for i = 1:size(A,1),
    switch i,
        case 1,
            mk = 'r-';
        case 2,
            mk = 'b-';
        case 3,
            mk = 'm-';
        case 4,
            mk = 'k-';
        case 5,
            mk = 'g-';
        case 6,
            mk = 'c-';
        otherwise
            mk = 'y-';
    end
    %---------------------------------------------------------------------
    plot(x1(i,:),x2(i,:),mk,'LineWidth',2)
    if type == 2,
        drawnow
        pause
    end
end
%=========================================================================
if type == 2 || type == 3,
    [xm1,xm2] = meshgrid(xt1,xt2);
    for i = 1:size(xm1,1),
        for j = 1:size(xm1,2),
            zm(i,j) = xm1(i,j)*c(1) + xm2(i,j)*c(2);
        end
    end
    contour(xm1,xm2,zm,ncontour)
end
%=========================================================================
hold off
if type == 3,
    figure
    mesh(xm1,xm2,zm)
end
%=========================================================================