clear all
close all
clc

%Gerando uma instancia aleatoria do GAP

n = 20;
m = 5;
p = ceil(25*rand(m,n));

%-------------------------------------------------------------------------
sense1 = '';
A1 = zeros(n,n*m+1);
for i = 1:n
    for j = 1:m
        A1(i,(j-1)*n+i) = 1;
    end
    sense1 = strcat(sense1,'=');
end
B1 = ones(n,1);
%-------------------------------------------------------------------------
sense2 = '';
A2 = zeros(m,n*m+1);
for i = 1:m
    A2(i,((i-1)*n+1):i*n) = p(i,:);
    sense2 = strcat(sense2,'<');
    A2(i,n*m+1) = -1;
end
B2 = zeros(m,1);
%-------------------------------------------------------------------------
vtype = '';
for i = 1:n*m
    vtype = strcat(vtype,'B');
end
vtype = strcat(vtype,'C');
%-------------------------------------------------------------------------
    
model.A = sparse([A1 ; A2]);
model.obj = [zeros(1,n*m) 1];
model.rhs = [B1 ; B2];
model.sense = strcat(sense1,sense2);
model.vtype = vtype;
model.modelsense = 'min';
  
result = gurobi(model)

%-------------------------------------------------------------------------
for i = 1:m
    tarefasmaquinai = [result.x(((i-1)*n+1):i*n)]';
    fprintf('Maquina %d | Tempo: %d | Tarefas: \n',i,sum(p(i,find(tarefasmaquinai))))
    find(tarefasmaquinai)
end