clear all
close all
clc

%Gerando uma instancia aleatoria do problema de empacotamento de mochilas

n = 10;
wmax = 10;
w = ceil(wmax*rand(1,n));
cap = wmax;


%-------------------------------------------------------------------------
sense1 = '';
A1 = zeros(n,n*n+n);
for i = 1:n
    for j = 1:n
        pos = (j-1)*n + i;
        A1(i,pos) = 1;
    end
    sense1 = strcat(sense1,'=');
end
B1 = ones(n,1);
%-------------------------------------------------------------------------

%-------------------------------------------------------------------------
sense2 = '';
T1 = zeros(n,n*n);
T2 = zeros(n);
for i = 1:n
    T1(i,((i-1)*n+1):((i)*n)) = w;
    T2(i,i) = -cap;
    sense2 = strcat(sense2,'<');
end
A2 = [T1 T2];
B2 = zeros(n,1);
%-------------------------------------------------------------------------

%-------------------------------------------------------------------------
model.A = sparse([A1 ; A2]);
model.obj = [zeros(1,n*n) ones(1,n)];
model.rhs = [B1 ; B2];
model.sense = strcat(sense1,sense2);
model.vtype = 'B';
model.modelsense = 'min';
  
result = gurobi(model)
%-------------------------------------------------------------------------

%-------------------------------------------------------------------------
rmochilas = [result.x(n*n+1:n*n+n)]';
fprintf('Mochilas: \n')
find(rmochilas)
for i = 1:n
    ritensi = [result.x((i-1)*n+1:i*n)]';
    fprintf('Mochila %d | Flag: %d | Peso: %d/%d | Itens: \n',i,rmochilas(i),sum(w(find(ritensi))),cap);
    find(ritensi)
end